/**************************************************************************
 * jquery.themepunch.kenburn.js - jQuery Plugin for kenburn Slider
 * @version: 2.0 (09.02.2012)
 * @requires jQuery v1.2.2 or later 
 * @author Krisztian Horvath
**************************************************************************/




(function($,undefined){	
	
	
	
	////////////////////////////
	// THE PLUGIN STARTS HERE //
	////////////////////////////
	
	$.fn.extend({
	
		
		// OUR PLUGIN HERE :)
		simple: function(options) {
	
		
			
		////////////////////////////////
		// SET DEFAULT VALUES OF ITEM //
		////////////////////////////////
		var defaults = {	
			delay:3000,
			startwidth:1020,
			startheight:350,
			bulletContainer:'#bullets',
			bulletTyp:"simple",
			bulletThumbsWidth:120,
			bulletThumbsHeight:70,
			hideThumbs:300
		};
		
			options = $.extend({}, $.fn.simple.defaults, options);
		
				
					
			return this.each(function() {
											
					var opt=options;
				
				
				opt.slots=4;
				opt.act=-1;
				opt.next=0;
				
				opt.firefox13 = ($.browser.mozilla && parseInt($.browser.version,0)==13);
				
				
				if (opt.navOffsetHorizontal==undefined) opt.navOffsetHorizontal=0;
				if (opt.navOffsetVertical==undefined) opt.navOffsetVertical=0;
				
				opt.navOH = opt.navOffsetHorizontal;
				opt.navOV = opt.navOffsetVertical;
				
				
				
				var container=$(this);
				
				// SOME SPECIAL SETTINGS FOR THE BANNER HERE
				container.parent().parent().addClass("bstyle-"+opt.showThumbsInfos);
				if (!container.parent().parent().hasClass('homebanner')) {
					container.parent().parent().find('.bannernavholder').remove();
				}
								
				
				if (opt.showThumbsInfos!="ab" && opt.showThumbsInfos!="none") {
					
					container.parent().parent().find('.simplebannerbuttons').remove();
				}
				
				
				
				if (opt.showThumbsInfos=="leftthumbs") container.parent().parent().addClass("leftthumbs");
				if (opt.showThumbsInfos=="rightthumbs") container.parent().parent().addClass("rightthumbs");
				
				container.addClass("tp-simpleresponsive");
				opt.container=container;
				opt.slideamount = container.find('ul:first li').length;
				
				container.width(opt.startwidth);
				container.height(opt.startheight);
				
				container.parent().parent().height(opt.startheight);
				opt.width=container.width();
				opt.height=container.height();
				
				opt.bw = opt.startwidth / container.width();
				opt.bh = opt.startheight / container.height();
				
				
				if (opt.width!=opt.startwidth) {
					
					opt.height = Math.round(opt.startheight * (opt.width/opt.startwidth));
					container.height(opt.height);
					
				}
				
				container.parent().parent().find('.thumbsholder').height(opt.startheight - 60);
				
				container.waitForImages(function() {
						// PREPARE THE SLIDES
						prepareSlides(container,opt);				
						
						// CREATE BULLETS
						createThumbs(container,opt);
						
						
						if (opt.hideThumbs>0) hideThumbs(container,opt);
					
						container.waitForImages(function() {
							// START THE FIRST SLIDE
							setTimeout(function() { 
								swapSlide(container,opt);
								container.parent().parent().find('.banner').css({'opacity':1});
								arrowHandling(container,opt);
							},500);
						});
						
						// START COUNTDOWN
						countDown(container,opt);
				});
			})
		}

})


		/////////////////////
		//	ARROW HANDLING //
		////////////////////
		function arrowHandling(container,opt) {
						container.parent().parent().hover(function() {
								$(this).find('.simplebannerbuttons').fadeIn(300);
						},
						function() {
							$(this).find('.simplebannerbuttons').fadeOut(300);
						});
						
						container.parent().parent().find('.simplebannerbuttons').fadeOut(300);
			// 	THE LEFT / RIGHT BUTTON CLICK !	 //
				
						container.parent().parent().find('#bannerright, .bbleft').click(function() {
							
							if (opt.transition==0) {
									opt.next = opt.next+1;						
									if (opt.next == opt.slideamount) opt.next=0;
									opt.cd=0;
									swapSlide(container,opt);
									
									// STOP TIMER AND RESCALE IT 
									try{
										var bt=	container.find('.tp-bannertimer');							
										if (bt.length>0) {
											bt.stop();
											bt.css({'width':'0%'});
											bt.animate({'width':"100%"},{duration:(opt.delay-100),queue:false, easing:"linear"});
										}
									} catch (e) {}
							}
						});
						
						container.parent().parent().find('#bannerleft, .bbright').click(function() {
							if (opt.transition==0) {
									opt.next = opt.next-1;						
									if (opt.next < 0) opt.next=opt.slideamount-1;
									opt.cd=0;
									swapSlide(container,opt);
									
									// STOP TIMER AND RESCALE IT 
									try{
										var bt=	container.find('.tp-bannertimer');							
										if (bt.length>0) {
											bt.stop();
											bt.css({'width':'0%'});
											bt.animate({'width':"100%"},{duration:(opt.delay-100),queue:false, easing:"linear"});
										}
									} catch (e) {}
							}
						});
		}
		
		
		//////////////////////////
		//	CONTAINER RESIZED	//
		/////////////////////////
		function containerResized(container,opt) {
			
			
			container.find('.defaultimg').each(function() {
						
						setSize($(this),opt);
						
						opt.height = Math.round(opt.startheight * (opt.width/opt.startwidth));
						container.height(opt.height);															
						
						
						var actsh = container.find('li:eq('+opt.act+') .slotholder');
						var nextsh = container.find('li:eq('+opt.next+') .slotholder');
						removeSlots(container);
						
						//nextsh.find('.defaultimg').css({'opacity':0});
						//actsh.find('.defaultimg').css({'opacity':1});
						
						setCaptionPositions(container,opt);
						
						var nextli = container.find('li:eq('+opt.next+')');
						container.find('.caption').each(function() { $(this).stop(true,true);});
						animateTheCaptions(nextli, opt);		
						
						var bullets = $('body').find(opt.bulletContainer);
						
						if (opt.bulletTyp=="long") {									
								opt.bulletThumbsWidth = (-1+(container.parent().outerWidth() / opt.slideamount));
								opt.bulletThumbsHeight = (opt.bulletThumbsWidth/opt.oldBTW) * opt.oldBTH;								
								bullets.find('.thumbdecorholder').css({'width':opt.bulletThumbsWidth+"px", 'height':opt.bulletThumbsHeight+"px"});
								bullets.find('.bulletthumb').each(function() {
								$(this).css({'width':opt.bulletThumbsWidth+"px", 'height':opt.bulletThumbsHeight+"px"});
						});
						} 
						
						bullets.find('.bullet').each(function() {
							var bul = $(this);
							bul.css({'width':(-1+(container.parent().outerWidth() / opt.slideamount))+"px"});
						});
						
						opt.cd=0;
						try{
							var bt=container.find('.bannertimer');
							if (bt.length>0) {
								bt.css({'width':'0%'});
								bt.animate({'width':"100%"},{duration:(opt.delay-100),queue:false, easing:"linear"});
							}
						} catch(e) {}
						
						
						
				});
		}
		
		
		
		
		
		
		
		////////////////////////////////
		//	-	CREATE THE BULLETS -  //
		////////////////////////////////
		function createBullets(container,opt) {
			
				container.closest('.mediaholder').css({'overflow':'visible'});
				container.closest('.mediaholder').find('.bannernavholder').remove();
				container.parent().append('<div class="bulletholder"></div>');
				var bullets = container.parent().find('.bulletholder');
				container.find('ul:first li').each(function(i) {
							bullets.append('<div class="bullet"></div>');				
				});							
				
				var bullet= bullets.find('.bullet:first');				
				
				// ADD THE BULLETS HERE
				
				var mwidth=0;
				bullets.find('.bullet').each(function(i) {
					var bul = $(this);
					
					if (i==0) bul.addClass('first');
					if (i==opt.slideamount-1) bul.addClass('last');
					
					
					
					bul.click(function() {
						
						if (opt.transition==0 && bul.index() != opt.act) {
							opt.next = bul.index();						
							opt.cd=0;
							swapSlide(container,opt);
							
							// STOP TIMER AND RESCALE IT 
							try{
								var bt=	container.find('.bannertimer');							
								if (bt.length>0) {
									bt.stop();
									bt.css({'width':'0%'});
									bt.animate({'width':"100%"},{duration:(opt.delay-100),queue:false, easing:"linear"});
								}
							} catch (e) {}
							
						} else {
							
						}
					});	
					
					mwidth=mwidth+bul.outerWidth(true);					
				});
			
			mwidth=mwidth-10;
			bullets.width(mwidth);
			bullets.css({'left':(opt.width/2 - mwidth/2)+"px",'top':opt.height+"px"});
			bullets.append('<div style="clear:both"></div>');
			
			
			
			
			
			
			// SHOW AND HIDE THE THUMBS IF MOUE GOES OUT OF THE BANNER
			if (bullets.data('hidethumbs')>0) {
			
					bullets.css({'opacity':0});
					
					bullets.live('mouseenter', function() {
						var bullets=$('body').find(opt.bulletContainer);
						bullets.addClass("hovered");	
						clearTimeout(bullets.data('hidethumbs'));
						bullets.animate({'opacity':1},{duration:200,queue:false});
					});
					
					bullets.live('mouseleave', function() {
						var bullets=$('body').find(opt.bulletContainer)
						bullets.removeClass("hovered");		
						if (!container.hasClass("hovered") && !bullets.hasClass("hovered"))
							bullets.data('hidethumbs', setTimeout(function() { bullets.animate({'opacity':0},{duration:200,queue:false});},opt.hideThumbs));
					});
					
					
					
					container.live('mouseenter', function() {
						var bullets=$('body').find(opt.bulletContainer);
						bullets.addClass("hovered");	
						clearTimeout(bullets.data('hidethumbs'));
						bullets.animate({'opacity':1},{duration:200,queue:false});
					});
					
					container.live('mouseleave', function() {
						var bullets=$('body').find(opt.bulletContainer)
						bullets.removeClass("hovered");		
						if (!container.hasClass("hovered") && !bullets.hasClass("hovered"))
							bullets.data('hidethumbs', setTimeout(function() { bullets.animate({'opacity':0},{duration:200,queue:false});},opt.hideThumbs));
					});
			}
		}


		
		
		
		////////////////////////////////
		//	-	CREATE THE BULLETS -  //
		////////////////////////////////
		function createThumbs(container,opt) {
			
			
			container.parent().parent().find('.thumbsholder').append('<div class="tp-bullets tp-thumbs '+opt.navigationStyle+'"><div class="tp-mask"><div class="tp-thumbcontainer"></div></div></div>');																		
			
			var bullets = container.parent().parent().find('.tp-bullets.tp-thumbs .tp-mask .tp-thumbcontainer');
			
			container.find('ul:first li').each(function(i) {
							var src=container.find("ul:first li:eq("+i+") img:first").attr('src');
							bullets.append('<div class="bullet thumb"><div class="imagemask"><img src="'+src+'"></div><div class="cover"></div></div>');											
							var bullet= bullets.find('.bullet:first');				
				});
			bullets.append('<div style="clear:both"></div>');			
			var minheight=1000;
			// ADD THE BULLET CLICK FUNCTION HERE
			bullets.find('.bullet').each(function(i) {
				var bul = $(this);
				
				if (i==opt.slideamount-1) bul.addClass('last');
				if (i==0) bul.addClass('first');
				
				if (minheight>bul.outerHeight(true)) minheight=bul.outerHeight(true);				
				
				bul.click(function() {
					if (opt.transition==0 && bul.index() != opt.act) {
						opt.next = bul.index();						
						opt.cd=0;
						swapSlide(container,opt);
						
						// STOP TIMER AND RESCALE IT 
							var bt=	container.find('.tp-bannertimer');							
							if (bt.length>0) {
								bt.stop();
								bt.css({'width':'0%'});
								bt.animate({'width':"100%"},{duration:(opt.delay-100),queue:false, easing:"linear"});
							}
							
						
					} else {
						
					}
				});				
			});
			
			
			var max=minheight*container.find('ul:first li').length;
			var thumbconheight=bullets.parent().height();			
			opt.thumbWidth = minheight;
			
			
			
			
				////////////////////////							
				// SLIDE TO POSITION  //
				////////////////////////							
				if (thumbconheight<max) {
					$(document).mousemove(function(e) {
						$('body').data('mousey',e.pageY);							
					});
					
				
					
					// ON MOUSE MOVE ON THE THUMBNAILS EVERYTHING SHOULD MOVE :)
					
					bullets.parent().mouseenter(function() {
							var $this=$(this);
							
							$this.addClass("over");	
							var offset = $this.offset();
							var y = $('body').data('mousey')-offset.top;									
							var thumbconheight=$this.height();	
							var minheight=$this.find('.bullet:first').outerHeight(true);
							var max=minheight*container.find('ul:first li').length;
							var diff=(max- thumbconheight)+150;		
							var steps = diff / thumbconheight;
							y=y-30;
							//if (x<30) x=0;
							//if (x>thumbconwidth-30) x=thumbconwidth;
															
							//ANIMATE TO POSITION
							var pos=(0-((y)*steps));										
							if (pos>0) pos =0;
							if (pos<0-max+thumbconheight) pos=0-max+thumbconheight;															
							moveThumbSliderToPosition($this,pos,200);							
						
					});
					
					bullets.parent().mousemove(function() {
							
									var $this=$(this);														
									
									//if (!$this.hasClass("over")) {
											var offset = $this.offset();
											var y = $('body').data('mousey')-offset.left;									
											var thumbconheight=$this.height();	
											var minheight=$this.find('.bullet:first').outerHeight(true);
											var max=minheight*container.find('ul:first li').length;
											var diff=(max- thumbconheight)+150;		
											var steps = diff / thumbconheight;
											y=y-30;
											//if (x<30) x=0;
											//if (x>thumbconwidth-30) x=thumbconwidth;
																			
											//ANIMATE TO POSITION
											var pos=(0-((y)*steps));										
											if (pos>0) pos =0;
											if (pos<0-max+thumbconheight) pos=0-max+thumbconheight;															
											moveThumbSliderToPosition($this,pos,200);
									//} else {
										//$this.removeClass("over");
									//}
									
					});
					
					bullets.parent().mouseleave(function() {
									var $this=$(this);
									$this.removeClass("over");	
									moveSelectedThumb(container);
					});
					
					

				}
				
				
		}
		
		
		///////////////////////////////
		//	SelectedThumbInPosition //
		//////////////////////////////
		function moveSelectedThumb(container) {
									
									var bullets=container.parent().parent().find('.tp-bullets.tp-thumbs .tp-mask .tp-thumbcontainer');														
									var $this=bullets.parent();
									var offset = $this.offset();
									var minheight=$this.find('.bullet:first').outerHeight(true);
									
									var y = $this.parent().parent().find('.bullet.selected').index() * minheight;	
									var thumbconheight=$this.height();	
									var minheight=$this.find('.bullet:first').outerHeight(true);
									var max=minheight*container.find('ul:first li').length;
									var diff=(max- thumbconheight);		
									var steps = diff / thumbconheight;
									
									//ANIMATE TO POSITION
									var pos=0-y;
								
									if (pos>0) pos =0;
									if (pos<0-max+thumbconheight) pos=0-max+thumbconheight;
									if (!$this.hasClass("over")) {
										moveThumbSliderToPosition($this,pos,200);
									}
		}
		
		
		////////////////////////////////////
		//	MOVE THUMB SLIDER TO POSITION //
		///////////////////////////////////
		function moveThumbSliderToPosition($this,pos,speed) {
			$this.stop();														
			$this.find('.tp-thumbcontainer').animate({'top':pos+'px'},{duration:speed,queue:false});																			
		}
		
		
		
		
		//////////////////////////////////////////////////////////
		//	-	SET THE IMAGE SIZE TO FIT INTO THE CONTIANER -  //
		////////////////////////////////////////////////////////
		function setSize(img,opt) {
		
		    
			opt.width=parseInt(opt.container.width(),0);
			opt.height=parseInt(opt.container.height(),0);
			
			opt.bw = opt.width / opt.startwidth;
			opt.bh = opt.height / opt.startheight;
			
			if (opt.bh>1) {
							opt.bw=1;
							opt.bh=1;
						}
			
			
			// IF IMG IS ALREADY PREPARED, WE RESET THE SIZE FIRST HERE
			if (img.data('orgw')!=undefined) {
				img.width(img.data('orgw'));
				img.height(img.data('orgh'));				
			}
			
			
			var fw = opt.width / img.width();
			var fh = opt.height / img.height();
			
			
			opt.fw = fw;
			opt.fh = fh;
			
			if (img.data('orgw')==undefined) {
				img.data('orgw',img.width());
				img.data('orgh',img.height());
			}
			
			
			
			if (opt.fullWidth=="on") {
					
					var cow = opt.container.parent().width();
					var coh = opt.container.parent().height();
					var ffh = coh / img.data('orgh');
					var ffw = cow / img.data('orgw');
					
					
					img.width(img.width()*ffh);
					img.height(coh);	
					
					if (img.width()<cow) {
						img.width(cow+50);						
						var ffw = img.width() / img.data('orgw');
						img.height(img.data('orgh')*ffw);
					}
					
					if (img.width()>cow) {
						img.data("fxof",(cow/2 - img.width()/2));							
						img.css({'position':'absolute','left':img.data('fxof')+"px"});
					}
										
			
			} else {
			
					img.width(opt.width);
					img.height(img.height()*fw);				
					
					if (img.height()<opt.height && img.height()!=0 && img.height()!=null) {
						
						img.height(opt.height);
						img.width(img.data('orgw')*fh);
					}
			}
			
			
			
			img.data('neww',img.width());
			img.data('newh',img.height());
			if (opt.fullWidth=="on") {
				opt.slotw=Math.ceil(img.width()/opt.slots);
			} else {
				opt.slotw=Math.ceil(opt.width/opt.slots);
			}
			opt.sloth=Math.ceil(opt.height/opt.slots);
			
		}
		
		
		
		
		/////////////////////////////////////////
		//	-	PREPARE THE SLIDES / SLOTS -  //
		///////////////////////////////////////
		function prepareSlides(container,opt) {
		
			container.find('.caption').each(function() { $(this).addClass($(this).data('transition')); $(this).addClass('start') });
			
			container.find('ul:first >li').each(function(j) {
				var li=$(this);
				if (li.data('link')!=undefined) {
					var link = li.data('link');
					li.append('<div class="caption sft slidelink" data-x="0" data-y="0" data-start="0"><a href="'+link+'"><div></div></a></div>');
					
				}
			});
			
			container.find('ul:first li >img').each(function(j) {

				var img=$(this);	
				img.addClass('defaultimg');				
				setSize(img,opt);				
				img.wrap('<div class="slotholder"></div>');
				img.css({'opacity':0});		
				img.data('li-id',j);
								
			});					
		}
		
		
		///////////////////////
		// PREPARE THE SLIDE //
		//////////////////////
		function prepareOneSlide(slotholder,opt,visible) {
				
				var sh=slotholder;					
				var img = sh.find('img')
				setSize(img,opt)
				var src = img.attr('src');
				var w = img.data('neww');
				var h = img.data('newh');
				var fulloff = img.data("fxof");
				if (fulloff==undefined) fulloff=0;
				
				
				var off=0;
				
				
				if (!visible) 
					var off=0-opt.slotw;
					
				for (var i=0;i<opt.slots;i++) 				
					sh.append('<div class="slot" style="position:absolute;top:0px;left:'+(fulloff+i*opt.slotw)+'px;overflow:hidden;width:'+opt.slotw+'px;height:'+h+'px"><div class="slotslide" style="position:absolute;top:0px;left:'+off+'px;width:'+opt.slotw+'px;height:'+h+'px;overflow:hidden;"><img style="position:absolute;top:0px;left:'+(0-(i*opt.slotw))+'px;width:'+w+'px;height:'+h+'px" src="'+src+'"></div></div>');									
											
		}
		
		
		///////////////////////
		// PREPARE THE SLIDE //
		//////////////////////
		function prepareOneSlideV(slotholder,opt,visible) {
				
				var sh=slotholder;					
				var img = sh.find('img')
				setSize(img,opt)
				var src = img.attr('src');
				var w = img.data('neww');
				var h = img.data('newh');
				var fulloff = img.data("fxof");
				if (fulloff==undefined) fulloff=0;
				var off=0;
				
				
				if (!visible) 
					var off=0-opt.sloth;
				
				for (var i=0;i<opt.slots;i++) 				
					sh.append('<div class="slot" style="position:absolute;top:'+(i*opt.sloth)+'px;left:'+(fulloff)+'px;overflow:hidden;width:'+w+'px;height:'+(opt.sloth)+'px"><div class="slotslide" style="position:absolute;top:'+off+'px;left:0px;width:'+w+'px;height:'+opt.sloth+'px;overflow:hidden;"><img style="position:absolute;top:'+(0-(i*opt.sloth))+'px;left:0px;width:'+w+'px;height:'+h+'px" src="'+src+'"></div></div>');									
											
		}
		
		
		///////////////////////
		// PREPARE THE SLIDE //
		//////////////////////
		function prepareOneSlideBox(slotholder,opt,visible) {
				
				var sh=slotholder;					
				var img = sh.find('img')
				setSize(img,opt)
				var src = img.attr('src');
				var w = img.data('neww');
				var h = img.data('newh');
				var fulloff = img.data("fxof");
				if (fulloff==undefined) fulloff=0;
				var off=0;
				
				
				
				
				// SET THE MINIMAL SIZE OF A BOX
				var basicsize = 0;
				if (opt.sloth>opt.slotw)  
					basicsize=opt.sloth
				else
					basicsize=opt.slotw;
				
				
				if (!visible) {
					var off=0-basicsize;
				}
				
				opt.slotw = basicsize;
				opt.sloth = basicsize;
				var x=0;
				var y=0;
				
				
				
				for (var j=0;j<opt.slots;j++) {
					
					y=0;
					for (var i=0;i<opt.slots;i++) 	{			
						
						
						sh.append('<div class="slot" '+
								  'style="position:absolute;'+
											'top:'+y+'px;'+
											'left:'+(fulloff+x)+'px;'+
											'width:'+basicsize+'px;'+
											'height:'+basicsize+'px;'+
											'overflow:hidden;">'+
											
								  '<div class="slotslide" data-x="'+x+'" data-y="'+y+'" '+
								  'style="position:absolute;'+
											'top:'+(0)+'px;'+
											'left:'+(0)+'px;'+
											'width:'+basicsize+'px;'+
											'height:'+basicsize+'px;'+
											'overflow:hidden;">'+
											
								  '<img style="position:absolute;'+
											'top:'+(0-y)+'px;'+
											'left:'+(0-x)+'px;'+
											'width:'+w+'px;'+
											'height:'+h+'px"'+
								  'src="'+src+'"></div></div>');									
						y=y+basicsize;						
					}
					x=x+basicsize;
				}
		}
		
		
		
		
		
		///////////////////////
		//	REMOVE SLOTS	//
		/////////////////////
		function removeSlots(container) {
			
			container.find('.slotholder .slot').each(function() {
				clearTimeout($(this).data('tout'));
				$(this).remove();
			});
			
		}
		
		
		////////////////////////
		//	CAPTION POSITION  //
		///////////////////////
		function setCaptionPositions(container,opt) {
			
			// FIND THE RIGHT CAPTIONS
			var actli = container.find('li:eq('+opt.act+')');
			var nextli = container.find('li:eq('+opt.next+')');
						
			// SET THE NEXT CAPTION AND REMOVE THE LAST CAPTION
			var nextcaption=nextli.find('.caption');
			
			if (nextcaption.find('iframe')==0) {
							
				// MOVE THE CAPTIONS TO THE RIGHT POSITION
				if (nextcaption.hasClass('hcenter'))
					nextcaption.css({'height':opt.height+"px",'top':'0px','left':(opt.width/2 - nextcaption.outerWidth()/2)+'px'});
				else
					if (nextcaption.hasClass('vcenter'))
						nextcaption.css({'width':opt.width+"px",'left':'0px','top':(opt.height/2 - nextcaption.outerHeight()/2)+'px'});			
			}
		}
		
			
			
			
		//////////////////////////////
		//                         //
		//	-	SWAP THE SLIDES -  //
		//                        //
		////////////////////////////
		function swapSlide(container,opt) {
			
			
			opt.transition = 1;
			
			try {
				var actli = container.find('li:eq('+opt.act+')');
			} catch(e) {  
				var actli=container.find('li:eq(1)');
			}
			
			var nextli = container.find('li:eq('+opt.next+')');
			var actsh = actli.find('.slotholder');
			var nextsh = nextli.find('.slotholder');
			actli.css({'visibility':'visible'});
			nextli.css({'visibility':'visible'});
			
			if ($.browser.msie && $.browser.version<9) {
				if (nextli.data('transition')=="boxfade") nextli.data('transition',"boxslide");
				if (nextli.data('transition')=="slotfade-vertical") nextli.data('transition',"slotzoom-vertical");
				if (nextli.data('transition')=="slotfade-horizontal") nextli.data('transition',"slotzoom-horizontal");
			}
			
			var teasertext = container.parent().parent().find('.bannerslogans .teasertext');
			if (teasertext.length>0) {
			teasertext.fadeOut(300);
			}
			
			setTimeout(function() {
				
				container.parent().parent().find('.bannerslogans').html('<div class="teasertext"></div>');
				var teasertext = container.parent().parent().find('.bannerslogans .teasertext');
				teasertext.css({'opacity':0});
				teasertext.append('<div class="thumbtitle">'+nextli.data("thumbtitle")+'</div><div class="thumbdescription">'+nextli.data("thumbdesc")+'</div>');
				
				var tm = container.parent().parent().height() - teasertext.outerHeight(true);
				
				teasertext.css({'paddingTop':(20+tm/2)+"px"});
				teasertext.animate({'opacity':1},{duration:500});
				
			},300);
			
			
			// IF DELAY HAS BEEN SET VIA THE SLIDE, WE TAKE THE NEW VALUE, OTHER WAY THE OLD ONE...
			if (nextli.data('delay')!=undefined) {
						opt.cd=0;
						opt.delay=nextli.data('delay');						
			} else {
				opt.delay=opt.origcd;
			}
			
			// RESET POSITION AND FADES OF LI'S
			actli.css({'left':'0px','top':'0px'});
			nextli.css({'left':'0px','top':'0px'});
			
			/////////////////////////////////////////////
			// SET THE BULLETS SELECTED OR UNSELECTED  //
			/////////////////////////////////////////////
			
			
			container.parent().parent().parent().find(".bullet").each(function() {
				var bul = $(this);
				bul.removeClass("selected");								
				if (bul.index() == opt.next) bul.addClass('selected');
			});
			
			
			//////////////////////////////////////////////////////////////////
			// 		SET THE NEXT CAPTION AND REMOVE THE LAST CAPTION		//
			//////////////////////////////////////////////////////////////////					
					
					container.find('li').each(function() {
						var li = $(this);
						if (li.index!=opt.act && li.index!=opt.next) li.css({'z-index':16});
					});
					
					actli.css({'z-index':18});
					nextli.css({'z-index':20});
					nextli.css({'opacity':0});
			
			
			///////////////////////////
			//	ANIMATE THE CAPTIONS //
			///////////////////////////
			removeTheCaptions(actli,opt);
			animateTheCaptions(nextli, opt);		
			
			
		

			/////////////////////////////////////////////
			//	SET THE ACTUAL AMOUNT OF SLIDES !!     //
			//  SET A RANDOM AMOUNT OF SLOTS          //
			///////////////////////////////////////////
						if (nextli.data('slotamount')==undefined || nextli.data('slotamount')<1) {
							opt.slots=Math.round(Math.random()*12+4);
							if (nextli.data('transition')=="boxslide")
								opt.slots=Math.round(Math.random()*6+3);
						 } else {
							opt.slots=nextli.data('slotamount');
						}
			
			
		
			
			/////////////////////////////////////
			// THE SLOTSLIDE - TRANSITION I.  //
			////////////////////////////////////
			if (nextli.data('transition')=="boxslide") {
					
						if (opt.slots>15) opt.slots=15;
						
						nextli.css({'opacity':1});
						
						// PREPARE THE SLOTS HERE
						prepareOneSlideBox(actsh,opt,true);
						prepareOneSlideBox(nextsh,opt,false);
						
						//SET DEFAULT IMG UNVISIBLE
						nextsh.find('.defaultimg').css({'opacity':0});
						//actsh.find('.defaultimg').css({'opacity':0});

						
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT
						
						nextsh.find('.slotslide').each(function(j) {
							var ss=$(this);
							ss.css({'top':(0-opt.sloth)+"px",'left':(0-opt.slotw)+"px"});	
							
							
							setTimeout(function() {
									
									if (opt.firefox13)
											ss.animate({'top':"0px",'left':'0px'},{duration:(400),queue:false,complete:function() {
																	if (j==(opt.slots*opt.slots)-1) {
																		removeSlots(container);
																		nextsh.find('.defaultimg').css({'opacity':1});
																		actsh.find('.defaultimg').css({'opacity':0});
																		opt.act=opt.next;
																		opt.transition = 0;		
																		moveSelectedThumb(container);
																	}
																	
											}});
									
									else
									
											ss.cssAnimate({'top':"0px",'left':'0px'},{duration:(400),queue:false,complete:function() {
																	if (j==(opt.slots*opt.slots)-1) {
																		removeSlots(container);
																		nextsh.find('.defaultimg').css({'opacity':1});
																		actsh.find('.defaultimg').css({'opacity':0});
																		if ($.browser.msie && $.browser.version<9) actsh.find('.defaultimg').css({'opacity':1});
																		
																		opt.act=opt.next;
																		opt.transition = 0;		
																		moveSelectedThumb(container);
																	}
																	
											}});
							},j*15);
						});
			}
			
			
			
			/////////////////////////////////////
			// THE SLOTSLIDE - TRANSITION I.  //
			////////////////////////////////////
			if (nextli.data('transition')=="boxfade") {
					

						if (opt.slots>15) opt.slots=15;
						nextli.css({'opacity':1});
						
						// PREPARE THE SLOTS HERE
						//prepareOneSlideBox(actsh,opt,true);
						prepareOneSlideBox(nextsh,opt,false);
						
						//SET DEFAULT IMG UNVISIBLE
						nextsh.find('.defaultimg').css({'opacity':0});
						//actsh.find('.defaultimg').css({'opacity':0});

						
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT
						
						nextsh.find('.slotslide').each(function(j) {
							var ss=$(this);
							ss.css({'opacity':0});								
							ss.find('img').css({'opacity':0});
							ss.find('img').css({'top':(Math.random()*opt.slotw-opt.slotw)+"px",'left':(Math.random()*opt.slotw-opt.slotw)+"px"});	
							
							
							var rand=Math.random()*1000+500;
							if (j==(opt.slots*opt.slots)-1) rand=1500;
							if (opt.firefox13) {
									ss.find('img').animate({'opacity':1,'top':(0-ss.data('y'))+"px",'left':(0-ss.data('x'))+'px'},{duration:rand,queue:false});
									ss.animate({'opacity':1},{duration:rand,queue:false,complete:function() {
															if (j==(opt.slots*opt.slots)-1) {
																removeSlots(container);
																nextsh.find('.defaultimg').css({'opacity':1});
																actsh.find('.defaultimg').css({'opacity':0});
																opt.act=opt.next;
																opt.transition = 0;			
																		moveSelectedThumb(container);														
															}
															
									}});
							} else {
									ss.find('img').cssAnimate({'opacity':1,'top':(0-ss.data('y'))+"px",'left':(0-ss.data('x'))+'px'},{duration:rand,queue:false});
									ss.cssAnimate({'opacity':1},{duration:rand,queue:false,complete:function() {
															if (j==(opt.slots*opt.slots)-1) {
																removeSlots(container);
																nextsh.find('.defaultimg').css({'opacity':1});
																actsh.find('.defaultimg').css({'opacity':0});
																if ($.browser.msie && $.browser.version<9) actsh.find('.defaultimg').css({'opacity':1});
																opt.act=opt.next;
																opt.transition = 0;			
																		moveSelectedThumb(container);														
															}
															
									}});
							}
							
						});
			}
			
			
			/////////////////////////////////////
			// THE SLOTSLIDE - TRANSITION I.  //
			////////////////////////////////////
			if (nextli.data('transition')=="slotslide-horizontal") {
					

						
						nextli.css({'opacity':1});
						
						// PREPARE THE SLOTS HERE
						prepareOneSlide(actsh,opt,true);
						prepareOneSlide(nextsh,opt,false);
						
						//SET DEFAULT IMG UNVISIBLE
						nextsh.find('.defaultimg').css({'opacity':0});
						//actsh.find('.defaultimg').css({'opacity':0});

						// ALL OLD SLOTS SHOULD BE SLIDED TO THE RIGHT
						actsh.find('.slotslide').each(function() {
							var ss=$(this);	
							if (opt.firefox13) {							
									ss.animate({'left':opt.slotw+'px'},{duration:500,queue:false,complete:function() {
															removeSlots(container);
															nextsh.find('.defaultimg').css({'opacity':1});
															actsh.find('.defaultimg').css({'opacity':0});
															opt.act=opt.next;
															opt.transition = 0;			
																		moveSelectedThumb(container);													
															
									}});
								} else {
									ss.cssAnimate({'left':opt.slotw+'px'},{duration:500,queue:false,complete:function() {
															removeSlots(container);
															nextsh.find('.defaultimg').css({'opacity':1});
															actsh.find('.defaultimg').css({'opacity':0});
															opt.act=opt.next;
															opt.transition = 0;			
																		moveSelectedThumb(container);													
															
									}});
								}
						}); 
						
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT
						nextsh.find('.slotslide').each(function() {
							var ss=$(this);
							ss.css({'left':(0-opt.slotw)+"px"});				
							if (opt.firefox13) {
									ss.animate({'left':'0px'},{duration:500,queue:false,complete:function() {
															removeSlots(container);
															nextsh.find('.defaultimg').css({'opacity':1});
															actsh.find('.defaultimg').css({'opacity':0});
															if ($.browser.msie && $.browser.version<9) actsh.find('.defaultimg').css({'opacity':1});
															opt.act=opt.next;
															opt.transition = 0;		
																		moveSelectedThumb(container);													
															
									}});
							} else {
									ss.cssAnimate({'left':'0px'},{duration:500,queue:false,complete:function() {
															removeSlots(container);
															nextsh.find('.defaultimg').css({'opacity':1});
															actsh.find('.defaultimg').css({'opacity':0});
															opt.act=opt.next;
															opt.transition = 0;		
																		moveSelectedThumb(container);													
															
									}});
							}
						});
			}
			
			
			
			/////////////////////////////////////
			// THE SLOTSLIDE - TRANSITION I.  //
			////////////////////////////////////
			if (nextli.data('transition')=="slotslide-vertical") {
					

						
						nextli.css({'opacity':1});
						
						// PREPARE THE SLOTS HERE
						prepareOneSlideV(actsh,opt,true);
						prepareOneSlideV(nextsh,opt,false);
						
						//SET DEFAULT IMG UNVISIBLE
						nextsh.find('.defaultimg').css({'opacity':0});
						//actsh.find('.defaultimg').css({'opacity':0});

						// ALL OLD SLOTS SHOULD BE SLIDED TO THE RIGHT
						actsh.find('.slotslide').each(function() {
							var ss=$(this);			
							if (opt.firefox13) {							
									ss.animate({'top':opt.sloth+'px'},{duration:500,queue:false,complete:function() {
															removeSlots(container);
															nextsh.find('.defaultimg').css({'opacity':1});
															actsh.find('.defaultimg').css({'opacity':0});
															opt.act=opt.next;
															opt.transition = 0;		
																		moveSelectedThumb(container);													
															
									}});
							} else {
									ss.cssAnimate({'top':opt.sloth+'px'},{duration:500,queue:false,complete:function() {
															removeSlots(container);
															nextsh.find('.defaultimg').css({'opacity':1});
															actsh.find('.defaultimg').css({'opacity':0});
															if ($.browser.msie && $.browser.version<9) actsh.find('.defaultimg').css({'opacity':1});
															opt.act=opt.next;
															opt.transition = 0;		
																		moveSelectedThumb(container);													
															
									}});
							}
						}); 
						
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT
						nextsh.find('.slotslide').each(function() {
							var ss=$(this);
							ss.css({'top':(0-opt.sloth)+"px"});	
							if (opt.firefox13) {									
								ss.animate({'top':'0px'},{duration:500,queue:false,complete:function() {
													removeSlots(container);
													nextsh.find('.defaultimg').css({'opacity':1});
													actsh.find('.defaultimg').css({'opacity':0});
													opt.act=opt.next;
													opt.transition = 0;		
																moveSelectedThumb(container);													
													
								}});
							} else {
								ss.cssAnimate({'top':'0px'},{duration:500,queue:false,complete:function() {
													removeSlots(container);
													nextsh.find('.defaultimg').css({'opacity':1});
													actsh.find('.defaultimg').css({'opacity':0});
													if ($.browser.msie && $.browser.version<9) actsh.find('.defaultimg').css({'opacity':1});
													opt.act=opt.next;
													opt.transition = 0;		
																moveSelectedThumb(container);													
													
								}});
							}
						});
			}
			
			
			
			/////////////////////////////////////
			// THE SLOTSLIDE - TRANSITION I.  //
			////////////////////////////////////
			if (nextli.data('transition')=="curtain-1") {
					

						
						nextli.css({'opacity':1});
						
						// PREPARE THE SLOTS HERE
						prepareOneSlide(actsh,opt,true);
						prepareOneSlide(nextsh,opt,true);
						
						//SET DEFAULT IMG UNVISIBLE
						nextsh.find('.defaultimg').css({'opacity':0});
						actsh.find('.defaultimg').css({'opacity':0});

						
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT
						actsh.find('.slotslide').each(function(i) {
							var ss=$(this);							
							
							ss.cssAnimate({'top':(0+(opt.height))+"px",'opacity':1},{duration:300+(i*(70-opt.slots)),queue:false,complete:function() {
													
													
							}});
						});
						
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT
						nextsh.find('.slotslide').each(function(i) {
							var ss=$(this);							
							ss.css({'top':(0-(opt.height))+"px",'opacity':0});				
							if (opt.firefox13) {
									ss.animate({'top':'0px','opacity':1},{duration:300+(i*(70-opt.slots)),queue:false,complete:function() {
															if (i==opt.slots-1) {
																removeSlots(container);
																nextsh.find('.defaultimg').css({'opacity':1});
																actsh.find('.defaultimg').css({'opacity':0});
																opt.act=opt.next;
																opt.transition = 0;	
																		moveSelectedThumb(container);														
															}
															
									}});
							} else {
									ss.cssAnimate({'top':'0px','opacity':1},{duration:300+(i*(70-opt.slots)),queue:false,complete:function() {
															if (i==opt.slots-1) {
																removeSlots(container);
																nextsh.find('.defaultimg').css({'opacity':1});
																actsh.find('.defaultimg').css({'opacity':0});
																if ($.browser.msie && $.browser.version<9) actsh.find('.defaultimg').css({'opacity':1});
																opt.act=opt.next;
																opt.transition = 0;	
																		moveSelectedThumb(container);														
															}
															
									}});
							}
						});
			}
			
			
			/////////////////////////////////////
			// THE SLOTSLIDE - TRANSITION I.  //
			////////////////////////////////////
			if (nextli.data('transition')=="curtain-2") {
					

						
						nextli.css({'opacity':1});
						
						// PREPARE THE SLOTS HERE
						prepareOneSlide(actsh,opt,true);
						prepareOneSlide(nextsh,opt,true);
						
						//SET DEFAULT IMG UNVISIBLE
						nextsh.find('.defaultimg').css({'opacity':0});
						actsh.find('.defaultimg').css({'opacity':0});

						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT
						actsh.find('.slotslide').each(function(i) {
							var ss=$(this);							
							if (opt.firefox13) {
									ss.animate({'top':(0+(opt.height))+"px",'opacity':1},{duration:300+((opt.slots-i)*(70-opt.slots)),queue:false,complete:function() {																				
									}});
							} else {
									ss.cssAnimate({'top':(0+(opt.height))+"px",'opacity':1},{duration:300+((opt.slots-i)*(70-opt.slots)),queue:false,complete:function() {																				
									}});
							}
						});
						
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT
						nextsh.find('.slotslide').each(function(i) {
							var ss=$(this);							
							ss.css({'top':(0-(opt.height))+"px",'opacity':0});				
							if (opt.firefox13) {
									ss.animate({'top':'0px','opacity':1},{duration:300+((opt.slots-i)*(70-opt.slots)),queue:false,complete:function() {
															if (i==0) {
																removeSlots(container);
																nextsh.find('.defaultimg').css({'opacity':1});
																actsh.find('.defaultimg').css({'opacity':0});
																opt.act=opt.next;
																opt.transition = 0;		
																																moveSelectedThumb(container);
															}
															
									}});
							} else {
										ss.cssAnimate({'top':'0px','opacity':1},{duration:300+((opt.slots-i)*(70-opt.slots)),queue:false,complete:function() {
															if (i==0) {
																removeSlots(container);
																nextsh.find('.defaultimg').css({'opacity':1});
																actsh.find('.defaultimg').css({'opacity':0});
																if ($.browser.msie && $.browser.version<9) actsh.find('.defaultimg').css({'opacity':1});
																opt.act=opt.next;
																opt.transition = 0;		
																																moveSelectedThumb(container);
															}
															
									}});
							}
						});
			}
			
			
			/////////////////////////////////////
			// THE SLOTSLIDE - TRANSITION I.  //
			////////////////////////////////////
			if (nextli.data('transition')=="curtain-3") {
					

						
						nextli.css({'opacity':1});
						if (opt.slots<2) opt.slots=2;
						// PREPARE THE SLOTS HERE
						prepareOneSlide(actsh,opt,true);
						prepareOneSlide(nextsh,opt,true);
						
						//SET DEFAULT IMG UNVISIBLE
						nextsh.find('.defaultimg').css({'opacity':0});
						actsh.find('.defaultimg').css({'opacity':0});

						
						actsh.find('.slotslide').each(function(i) {
							var ss=$(this);							

							if (i<opt.slots/2)
								var tempo = (i+2)*60;
							else
								var tempo = (2+opt.slots-i)*60;
								
							if (opt.firefox13) {
									ss.animate({'top':(0+(opt.height))+"px",'opacity':1},{duration:300+tempo,queue:false,complete:function() {}});
							} else {
									ss.cssAnimate({'top':(0+(opt.height))+"px",'opacity':1},{duration:300+tempo,queue:false,complete:function() {}});
							}
						});
						
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT
						nextsh.find('.slotslide').each(function(i) {
							var ss=$(this);							
							ss.css({'top':(0-(opt.height))+"px",'opacity':0});		
							if (i<opt.slots/2)
								var tempo = (i+2)*60;
							else
								var tempo = (2+opt.slots-i)*60;
								
							if (opt.firefox13) {
									ss.animate({'top':'0px','opacity':1},{duration:300+tempo,queue:false,complete:function() {
															if (i==Math.round(opt.slots/2)) {
																removeSlots(container);
																nextsh.find('.defaultimg').css({'opacity':1});
																actsh.find('.defaultimg').css({'opacity':0});
																opt.act=opt.next;
																opt.transition = 0;		
																																moveSelectedThumb(container);
															}
															
									}});
							} else {
									ss.cssAnimate({'top':'0px','opacity':1},{duration:300+tempo,queue:false,complete:function() {
															if (i==Math.round(opt.slots/2)) {
																removeSlots(container);
																nextsh.find('.defaultimg').css({'opacity':1});
																actsh.find('.defaultimg').css({'opacity':0});
																if ($.browser.msie && $.browser.version<9) actsh.find('.defaultimg').css({'opacity':1});
																opt.act=opt.next;
																opt.transition = 0;		
																																moveSelectedThumb(container);
															}
															
									}});
							}
						});
			}
			
			
			////////////////////////////////////
			// THE SLOTSZOOM - TRANSITION II. //
			////////////////////////////////////						
			if (nextli.data('transition')=="slotzoom-horizontal") {
						

						nextli.css({'opacity':1});
						
						// PREPARE THE SLOTS HERE
						prepareOneSlide(actsh,opt,true);
						prepareOneSlide(nextsh,opt,true);
						
						//SET DEFAULT IMG UNVISIBLE
						nextsh.find('.defaultimg').css({'opacity':0});
						//actsh.find('.defaultimg').css({'opacity':0});

						// ALL OLD SLOTS SHOULD BE SLIDED TO THE RIGHT
						actsh.find('.slotslide').each(function() {
							var ss=$(this).find('img');		
							if (opt.firefox13) {
									ss.animate({'left':(0-opt.slotw/2)+'px',
												   'top':(0-opt.height/2)+'px',
												   'width':(opt.slotw*2)+"px",
												   'height':(opt.height*2)+"px",
												   opacity:0
													},{duration:1000,queue:false,complete:function() {
															removeSlots(container);
															nextsh.find('.defaultimg').css({'opacity':1});
															actsh.find('.defaultimg').css({'opacity':0});
															opt.transition = 0;													
															opt.act = opt.next;
																															moveSelectedThumb(container);
													}});
							}	else	{
							
										ss.cssAnimate({'left':(0-opt.slotw/2)+'px',
												   'top':(0-opt.height/2)+'px',
												   'width':(opt.slotw*2)+"px",
												   'height':(opt.height*2)+"px",
												   opacity:0
													},{duration:1000,queue:false,complete:function() {
															removeSlots(container);
															nextsh.find('.defaultimg').css({'opacity':1});
															actsh.find('.defaultimg').css({'opacity':0});
															if ($.browser.msie && $.browser.version<9) actsh.find('.defaultimg').css({'opacity':1});
															opt.transition = 0;													
															opt.act = opt.next;
																															moveSelectedThumb(container);
													}});
							}
						}); 
						
						
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT //
						///////////////////////////////////////////////////////////////
						nextsh.find('.slotslide').each(function(i) {
							var ss=$(this).find('img');
							ss.css({'left':(0)+'px',
									'top':(0)+'px',
									//'width':(opt.width*2)+"px",
									//'height':(opt.height*2)+"px",
									opacity:0});
							if (opt.firefox13) {
									ss.animate({'left':(0-i*opt.slotw)+'px',
												   'top':(0)+'px',
												   'width':(nextsh.find('.defaultimg').data('neww'))+"px",
												   'height':(nextsh.find('.defaultimg').data('newh'))+"px",
												   opacity:1
													},{duration:1000,queue:false});
							} else {
								 ss.cssAnimate({'left':(0-i*opt.slotw)+'px',
												   'top':(0)+'px',
												   'width':(nextsh.find('.defaultimg').data('neww'))+"px",
												   'height':(nextsh.find('.defaultimg').data('newh'))+"px",
												   opacity:1
													},{duration:1000,queue:false});
							}
						});
			}
			
			
			
			
			////////////////////////////////////
			// THE SLOTSZOOM - TRANSITION II. //
			////////////////////////////////////						
			if (nextli.data('transition')=="slotzoom-vertical") {
						

						nextli.css({'opacity':1});
						
						// PREPARE THE SLOTS HERE
						prepareOneSlideV(actsh,opt,true);
						prepareOneSlideV(nextsh,opt,true);
						
						//SET DEFAULT IMG UNVISIBLE
						nextsh.find('.defaultimg').css({'opacity':0});
						//actsh.find('.defaultimg').css({'opacity':0});

						// ALL OLD SLOTS SHOULD BE SLIDED TO THE RIGHT
						actsh.find('.slotslide').each(function() {
							var ss=$(this).find('img');				
							if (opt.firefox13) {
									ss.animate({'left':(0-opt.width/2)+'px',
												   'top':(0-opt.sloth/2)+'px',
												   'width':(opt.width*2)+"px",
												   'height':(opt.sloth*2)+"px",
												   opacity:0
													},{duration:1000,queue:false,complete:function() {
															removeSlots(container);
															nextsh.find('.defaultimg').css({'opacity':1});
															actsh.find('.defaultimg').css({'opacity':0});
															opt.transition = 0;													
															opt.act = opt.next;
															moveSelectedThumb(container);
													}});
							} else {
							
											ss.cssAnimate({'left':(0-opt.width/2)+'px',
												   'top':(0-opt.sloth/2)+'px',
												   'width':(opt.width*2)+"px",
												   'height':(opt.sloth*2)+"px",
												   opacity:0
													},{duration:1000,queue:false,complete:function() {
															removeSlots(container);
															nextsh.find('.defaultimg').css({'opacity':1});
															actsh.find('.defaultimg').css({'opacity':0});
															if ($.browser.msie && $.browser.version<9) actsh.find('.defaultimg').css({'opacity':1});
															opt.transition = 0;													
															opt.act = opt.next;
															moveSelectedThumb(container);
													}});
							}
						}); 
						
						
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT //
						///////////////////////////////////////////////////////////////
						nextsh.find('.slotslide').each(function(i) {
							var ss=$(this).find('img');
							ss.css({'left':(0)+'px',
									'top':(0)+'px',
									//'width':(opt.width*2)+"px",
									//'height':(opt.height*2)+"px",
									opacity:0});
							if (opt.firefox13) {		
									ss.animate({'left':(0)+'px',
												   'top':(0-i*opt.sloth)+'px',
												   'width':(nextsh.find('.defaultimg').data('neww'))+"px",
												   'height':(nextsh.find('.defaultimg').data('newh'))+"px",
												   opacity:1
													},{duration:1000,queue:false});
							} else {
									ss.cssAnimate({'left':(0)+'px',
												   'top':(0-i*opt.sloth)+'px',
												   'width':(nextsh.find('.defaultimg').data('neww'))+"px",
												   'height':(nextsh.find('.defaultimg').data('newh'))+"px",
												   opacity:1
													},{duration:1000,queue:false});
							}
						});
			}
			
			
			////////////////////////////////////////
			// THE SLOTSFADE - TRANSITION III.   //
			//////////////////////////////////////
			if (nextli.data('transition')=="slotfade-horizontal") {
					

					
						nextli.css({'opacity':1});
						
						opt.slots = opt.width/20;
						
						prepareOneSlide(nextsh,opt,true);
						
						
						//actsh.find('.defaultimg').css({'opacity':0});
						nextsh.find('.defaultimg').css({'opacity':0});
						
						var ssamount=0;
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT
						nextsh.find('.slotslide').each(function(i) {
							var ss=$(this);
							ssamount++;
							ss.css({'opacity':0});
							ss.data('tout',setTimeout(function() {	
											ss.animate({'opacity':1},{duration:300,queue:false});
											
											},i*4)
									);
							
						});
						
						setTimeout(function() {
									opt.transition = 0;
									opt.act = opt.next;	
									moveSelectedThumb(container);
							},(300+(ssamount*4)));
			}
			
			
			
			
			////////////////////////////////////////
			// THE SLOTSFADE - TRANSITION III.   //
			//////////////////////////////////////
			if (nextli.data('transition')=="slotfade-vertical") {
					

					
						nextli.css({'opacity':1});
						
						opt.slots = opt.height/20;
						
						prepareOneSlideV(nextsh,opt,true);
						
						
						//actsh.find('.defaultimg').css({'opacity':0});
						nextsh.find('.defaultimg').css({'opacity':0});
						
						var ssamount=0;
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT
						nextsh.find('.slotslide').each(function(i) {
							var ss=$(this);
							ssamount++;
							ss.css({'opacity':0});
							ss.data('tout',setTimeout(function() {	
											ss.animate({'opacity':1},{duration:300,queue:false});
											
											},i*4)
									);
							
						});
						
						setTimeout(function() {
									opt.transition = 0;
									opt.act = opt.next;	
									moveSelectedThumb(container);									
							},(300+(ssamount*4)));
			}
			
			
			///////////////////////////
			// SIMPLE FADE ANIMATION //
			///////////////////////////
			
			if (nextli.data('transition')=="fade") {
					

					
						nextli.css({'opacity':1});
						
						opt.slots = 1;
						
						prepareOneSlide(nextsh,opt,true);
						
						
						//actsh.find('.defaultimg').css({'opacity':0});
						nextsh.find('.defaultimg').css({'opacity':0});
						
						var ssamount=0;
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT
						nextsh.find('.slotslide').each(function(i) {
							var ss=$(this);
							ssamount++;
							ss.css({'opacity':0});
							ss.animate({'opacity':1},{duration:300,queue:false});							
						});
						
						setTimeout(function() {
									opt.transition = 0;
									opt.act = opt.next;	
									moveSelectedThumb(container);									
							},300);
			}
			
			
			
			
			
			if (nextli.data('transition')=="slideleft" || nextli.data('transition')=="slideup" || nextli.data('transition')=="slidedown" || nextli.data('transition')=="slideright") {
					
						nextli.css({'opacity':1});
						
						opt.slots = 1;
						
						prepareOneSlide(nextsh,opt,true);
						prepareOneSlide(actsh,opt,true);
						
						
						actsh.find('.defaultimg').css({'opacity':0});
						nextsh.find('.defaultimg').css({'opacity':0});
						
						var oow = opt.width;
						var ooh = opt.height;
						if (opt.fullWidth=="on") {
							oow=opt.container.parent().width();
							ooh=opt.container.parent().height();
							
						}
						
						// ALL NEW SLOTS SHOULD BE SLIDED FROM THE LEFT TO THE RIGHT						
						var ssn=nextsh.find('.slotslide')						
						if (nextli.data('transition')=="slideleft")
							ssn.css({'left':oow+"px"});
						else
							if (nextli.data('transition')=="slideright")
								ssn.css({'left':(0-opt.width)+"px"});
							else
								if (nextli.data('transition')=="slideup")
									ssn.css({'top':(ooh)+"px"});
								else
									if (nextli.data('transition')=="slidedown")
										ssn.css({'top':(0-opt.height)+"px"});
										
						if (opt.firefox13) {	
										ssn.animate({'left':'0px','top':'0px',opacity:1},{duration:1000,queue:false,complete:function() {
														removeSlots(container);
														nextsh.find('.defaultimg').css({'opacity':1});
														actsh.find('.defaultimg').css({'opacity':0});
														opt.transition = 0;													
														opt.act = opt.next;
														moveSelectedThumb(container);												
												}});					
						} else {
										ssn.cssAnimate({'left':'0px','top':'0px',opacity:1},{duration:1000,queue:false,complete:function() {
														removeSlots(container);
														nextsh.find('.defaultimg').css({'opacity':1});
														actsh.find('.defaultimg').css({'opacity':0});
														if ($.browser.msie && $.browser.version<9) actsh.find('.defaultimg').css({'opacity':1});
														opt.transition = 0;													
														opt.act = opt.next;
														moveSelectedThumb(container);												
												}});					
						}
										
						
						var ssa=actsh.find('.slotslide');
						if (opt.firefox13) {
								if (nextli.data('transition')=="slideleft")
									ssa.animate({'left':(0-oow)+'px',opacity:1},{duration:1000,queue:false});
								else
									if (nextli.data('transition')=="slideright")
										ssa.animate({'left':(oow)+'px',opacity:1},{duration:1000,queue:false});
									else
										if (nextli.data('transition')=="slideup")
											ssa.animate({'top':(0-ooh)+'px',opacity:1},{duration:1000,queue:false});
										else
											if (nextli.data('transition')=="slidedown")
												ssa.animate({'top':(ooh)+'px',opacity:1},{duration:1000,queue:false});
						} else {
								if (nextli.data('transition')=="slideleft")
									ssa.cssAnimate({'left':(0-oow)+'px',opacity:1},{duration:1000,queue:false});
								else
									if (nextli.data('transition')=="slideright")
										ssa.cssAnimate({'left':(oow)+'px',opacity:1},{duration:1000,queue:false});
									else
										if (nextli.data('transition')=="slideup")
											ssa.cssAnimate({'top':(0-ooh)+'px',opacity:1},{duration:1000,queue:false});
										else
											if (nextli.data('transition')=="slidedown")
												ssa.cssAnimate({'top':(ooh)+'px',opacity:1},{duration:1000,queue:false});
						}
						
						
						
						
			}
			
		
						
		}
		
				//////////////////////////
				//	REMOVE THE CAPTIONS //
				/////////////////////////				
				function removeTheCaptions(actli,opt) {
						actli.find('.caption').each(function(i) {
							var nextcaption=actli.find('.caption:eq('+i+')');																																							
							nextcaption.stop(true,true);
							clearTimeout(nextcaption.data('timer'));
							var easetype=nextcaption.data('easing');
							easetype="easeInOutSine";
							var ll = nextcaption.data('repx');
							var tt = nextcaption.data('repy');
							var oo = nextcaption.data('repo');

							
							if (nextcaption.find('iframe').length>0) {
									var par=nextcaption.find('iframe').parent();
									var iframe=par.html();
								setTimeout(function() {									
									nextcaption.find('iframe').remove();
									par.append(iframe);
								},nextcaption.data('speed'));
							}
							try {nextcaption.animate({'opacity':oo,'left':ll+'px','top':tt+"px"},{duration:nextcaption.data('speed'), easing:easetype});} catch(e) {}
						});
				}
		
				////////////////////////
				// SHOW THE CAPTION  //
				///////////////////////		
				function animateTheCaptions(nextli, opt) {
						
			
						nextli.find('.caption').each(function(i) {
						
								offsetx = opt.width/2 - opt.startwidth/2; 
						
								if (opt.bh>1) {							
									opt.bw=1;
									opt.bh=1;							
								}												
								var xbw = opt.bw;
								
								
								var nextcaption=nextli.find('.caption:eq('+i+')');																																							
								nextcaption.stop(true,true);
								
								
								if (nextcaption.hasClass("coloredbg")) offsetx=0;
								if (offsetx<0) offsetx=0;
								
								clearTimeout(nextcaption.data('timer'));
						
							   var imw =0;
							   var imh = 0;
							   
										if (nextcaption.find('img').length>0) {
											var im = nextcaption.find('img');
											if (im.data('ww') == undefined) im.data('ww',im.width());
											if (im.data('hh') == undefined) im.data('hh',im.height());
											
											var ww = im.data('ww');
											var hh = im.data('hh');
											
											
											im.width(ww*opt.bw);
											im.height(hh*opt.bh);
											imw = im.width();
											imh = im.height();
										} else {
										
											if (nextcaption.find('iframe').length>0) {
												var im = nextcaption.find('iframe');
												if (nextcaption.data('ww') == undefined) {
													nextcaption.data('ww',im.width());																										
												}
												if (nextcaption.data('hh') == undefined) nextcaption.data('hh',im.height());
												
												var ww = nextcaption.data('ww');
												var hh = nextcaption.data('hh');
												
												var nc =nextcaption;
													if (nc.data('fsize') == undefined) nc.data('fsize',parseInt(nc.css('font-size'),0) || 0);
													if (nc.data('pt') == undefined) nc.data('pt',parseInt(nc.css('paddingTop'),0) || 0);
													if (nc.data('pb') == undefined) nc.data('pb',parseInt(nc.css('paddingBottom'),0) || 0);
													if (nc.data('pl') == undefined) nc.data('pl',parseInt(nc.css('paddingLeft'),0) || 0);
													if (nc.data('pr') == undefined) nc.data('pr',parseInt(nc.css('paddingRight'),0) || 0);
													
													if (nc.data('mt') == undefined) nc.data('mt',parseInt(nc.css('marginTop'),0) || 0);
													if (nc.data('mb') == undefined) nc.data('mb',parseInt(nc.css('marginBottom'),0) || 0);
													if (nc.data('ml') == undefined) nc.data('ml',parseInt(nc.css('marginLeft'),0) || 0);
													if (nc.data('mr') == undefined) nc.data('mr',parseInt(nc.css('marginRight'),0) || 0);
													
													if (nc.data('bt') == undefined) nc.data('bt',parseInt(nc.css('borderTop'),0) || 0);
													if (nc.data('bb') == undefined) nc.data('bb',parseInt(nc.css('borderBottom'),0) || 0);
													if (nc.data('bl') == undefined) nc.data('bl',parseInt(nc.css('borderLeft'),0) || 0);
													if (nc.data('br') == undefined) nc.data('br',parseInt(nc.css('borderRight'),0) || 0);
													
													if (nc.data('lh') == undefined) nc.data('lh',parseInt(nc.css('lineHeight'),0) || 0);
																								
													
													nextcaption.css({
																	 'font-size': (nc.data('fsize') * opt.bw)+"px",
																	
																	 'padding-top': (nc.data('pt') * opt.bh) + "px",
																	 'padding-bottom': (nc.data('pb') * opt.bh) + "px",
																	 'padding-left': (nc.data('pl') * opt.bw) + "px",
																	 'padding-right': (nc.data('pr') * opt.bw) + "px",
																	 
																	 'margin-top': (nc.data('mt') * opt.bh) + "px",
																	 'margin-bottom': (nc.data('mb') * opt.bh) + "px",
																	 'margin-left': (nc.data('ml') * opt.bw) + "px",
																	 'margin-right': (nc.data('mr') * opt.bw) + "px",
																	 
																	 'border-top': (nc.data('bt') * opt.bh) + "px",
																	 'border-bottom': (nc.data('bb') * opt.bh) + "px",
																	 'border-left': (nc.data('bl') * opt.bw) + "px",
																	 'border-right': (nc.data('br') * opt.bw) + "px",
																	 
																	 'line-height': (nc.data('lh') * opt.bh) + "px",
																	 'height':(hh*opt.bh)+'px',
																	 'white-space':"nowrap"
																	 
																	 
													});
													
												im.width(ww*opt.bw);
												im.height(hh*opt.bh);
												imw = im.width();
												imh = im.height();
											} else {
											
													var nc =nextcaption;
													if (nc.data('fsize') == undefined) nc.data('fsize',parseInt(nc.css('font-size'),0) || 0);
													if (nc.data('pt') == undefined) nc.data('pt',parseInt(nc.css('paddingTop'),0) || 0);
													if (nc.data('pb') == undefined) nc.data('pb',parseInt(nc.css('paddingBottom'),0) || 0);
													if (nc.data('pl') == undefined) nc.data('pl',parseInt(nc.css('paddingLeft'),0) || 0);
													if (nc.data('pr') == undefined) nc.data('pr',parseInt(nc.css('paddingRight'),0) || 0);
													
													if (nc.data('mt') == undefined) nc.data('mt',parseInt(nc.css('marginTop'),0) || 0);
													if (nc.data('mb') == undefined) nc.data('mb',parseInt(nc.css('marginBottom'),0) || 0);
													if (nc.data('ml') == undefined) nc.data('ml',parseInt(nc.css('marginLeft'),0) || 0);
													if (nc.data('mr') == undefined) nc.data('mr',parseInt(nc.css('marginRight'),0) || 0);
													
													if (nc.data('bt') == undefined) nc.data('bt',parseInt(nc.css('borderTop'),0) || 0);
													if (nc.data('bb') == undefined) nc.data('bb',parseInt(nc.css('borderBottom'),0) || 0);
													if (nc.data('bl') == undefined) nc.data('bl',parseInt(nc.css('borderLeft'),0) || 0);
													if (nc.data('br') == undefined) nc.data('br',parseInt(nc.css('borderRight'),0) || 0);
													
													if (nc.data('lh') == undefined) nc.data('lh',parseInt(nc.css('lineHeight'),0) || 0);
																								
													
													nextcaption.css({
																	 'font-size': (nc.data('fsize') * opt.bw)+"px",
																	
																	 'padding-top': (nc.data('pt') * opt.bh) + "px",
																	 'padding-bottom': (nc.data('pb') * opt.bh) + "px",
																	 'padding-left': (nc.data('pl') * opt.bw) + "px",
																	 'padding-right': (nc.data('pr') * opt.bw) + "px",
																	 
																	 'margin-top': (nc.data('mt') * opt.bh) + "px",
																	 'margin-bottom': (nc.data('mb') * opt.bh) + "px",
																	 'margin-left': (nc.data('ml') * opt.bw) + "px",
																	 'margin-right': (nc.data('mr') * opt.bw) + "px",
																	 
																	 'border-top': (nc.data('bt') * opt.bh) + "px",
																	 'border-bottom': (nc.data('bb') * opt.bh) + "px",
																	 'border-left': (nc.data('bl') * opt.bw) + "px",
																	 'border-right': (nc.data('br') * opt.bw) + "px",
																	 
																	 'line-height': (nc.data('lh') * opt.bh) + "px",
																	 'white-space':"nowrap"
																	 
																	 
													});
													imh=nextcaption.outerHeight(true);
													imw=nextcaption.outerWidth(true);
												}
										}
								
										
								
								if (nextcaption.hasClass('fade')) {																						
									
									nextcaption.css({'opacity':0,'left':(xbw*nextcaption.data('x')+offsetx)+'px','top':(opt.bh*nextcaption.data('y'))+"px"});
								}
								
								
								
								if (nextcaption.hasClass('lfr')) {
									
									nextcaption.css({'opacity':1,'left':(5+opt.width)+'px','top':(opt.bh*nextcaption.data('y'))+"px"});
									
								}
								
								if (nextcaption.hasClass('lfl')) {
									
									nextcaption.css({'opacity':1,'left':(-5-imw)+'px','top':(opt.bh*nextcaption.data('y'))+"px"});
									
								}
								
								if (nextcaption.hasClass('sfl')) {
									
									nextcaption.css({'opacity':0,'left':((xbw*nextcaption.data('x'))-50+offsetx)+'px','top':(opt.bh*nextcaption.data('y'))+"px"});
								}
								
								if (nextcaption.hasClass('sfr')) {
									nextcaption.css({'opacity':0,'left':((xbw*nextcaption.data('x'))+50+offsetx)+'px','top':(opt.bh*nextcaption.data('y'))+"px"});
								}
								
								
								
								
								if (nextcaption.hasClass('lft')) {
									
									nextcaption.css({'opacity':1,'left':(xbw*nextcaption.data('x')+offsetx)+'px','top':(-5 - imh)+"px"});
									
								}
								
								if (nextcaption.hasClass('lfb')) {
									nextcaption.css({'opacity':1,'left':(xbw*nextcaption.data('x')+offsetx)+'px','top':(5+opt.height)+"px"});
									
								}
								
								if (nextcaption.hasClass('sft')) {
									nextcaption.css({'opacity':0,'left':(xbw*nextcaption.data('x')+offsetx)+'px','top':((opt.bh*nextcaption.data('y'))-50)+"px"});
								}
								
								if (nextcaption.hasClass('sfb')) {
									nextcaption.css({'opacity':0,'left':(xbw*nextcaption.data('x')+offsetx)+'px','top':((opt.bh*nextcaption.data('y'))+50)+"px"});
								}
								
								
								
								
								nextcaption.data('timer',setTimeout(function() { 
										if (nextcaption.hasClass('fade')) {																						
											nextcaption.animate({'opacity':1});
										}
										if (nextcaption.hasClass('lfr') || 
											nextcaption.hasClass('lfl') || 
											nextcaption.hasClass('sfr') || 
											nextcaption.hasClass('sfl') ||
											nextcaption.hasClass('lft') || 
											nextcaption.hasClass('lfb') || 
											nextcaption.hasClass('sft') || 
											nextcaption.hasClass('sfb')
											) 
										{	
											var easetype=nextcaption.data('easing');
											if (easetype==undefined) easetype="linear";
											nextcaption.data('repx',nextcaption.position().left);
											nextcaption.data('repy',nextcaption.position().top);
											
											nextcaption.data('repo',nextcaption.css('opacity'));
											nextcaption.animate({'opacity':1,'left':(xbw*nextcaption.data('x')+offsetx)+'px','top':opt.bh*(nextcaption.data('y'))+"px"},{duration:nextcaption.data('speed'), easing:easetype});
										}
								},nextcaption.data('start')));
								
						})
				}
		
		
		
		///////////////////////////
		//	-	COUNTDOWN	-	//
		/////////////////////////
		function countDown(container,opt) {
			opt.cd=0;
			
			//container.append('<div style="position:absolute;z-index:1000;top:10px;left:10px;background:#ff0000;" id="kk">TIMER</div>');
			var bt=container.find('.tp-bannertimer');
			if (bt.length>0) {
				bt.css({'width':'0%'});
				bt.animate({'width':"100%"},{duration:(opt.delay-100),queue:false, easing:"linear"});
			}
			opt.maindelay=opt.delay;
			opt.cdint=setInterval(function() {
				
				if (opt.conthover!=1) opt.cd=opt.cd+100;
				
				
				//$('#kk').html(opt.cd+"  "+opt.maindelay);
				if (opt.cd>=opt.maindelay) {
					opt.cd=0;
					// SWAP TO NEXT BANNER 
					opt.act=opt.next;
					opt.next=opt.next+1;
					if (opt.next>container.find('>ul >li').length-1) opt.next=0;
					
					
					// SWAP THE SLIDES
					swapSlide(container,opt);
					
					// Clear the Timer
					if (bt.length>0) {
						bt.css({'width':'0%'});
						bt.animate({'width':"100%"},{duration:(opt.delay-100),queue:false, easing:"linear"});
					}
				}
			},100);
			
			container.hover(
				function() {
					if (opt.onHoverStop=="on") {
						opt.conthover=1;
						bt.stop();
					}
				},
				function() {
					if (opt.onHoverStop=="on") {
						opt.conthover=0;
						bt.animate({'width':"100%"},{duration:((opt.delay-opt.cd)-100),queue:false, easing:"linear"});
					}
				});
		}

		
		
})(jQuery);			
